ActivateFullVersion = copy_table(BaseView)
ActivateFullVersion.definition = {
    {
        type = "Text",
        font = "clean_header30",
        text = sandy_str.demo_header,
        align = "left top",
        color = "424040",
        x=150, y=100, z=10,
    },

    {
        type = "Text",
        font = "clean20",
        text = sandy_str.demo_info,
        align = "left top",
        w = 500,
        color = "505050",
        x=150, y=145, z=10,
    },

    {
        type = "LabeledButton",
        shortcut = "buy_button",
        bitmap = "framework/gfx/button",
        bitmap_hi = "framework/gfx/button_hi",
        font = "clean20",
        text = sandy_str.button_buy,
        text_shift_y = 3,
        mouse_click = "yes_button",
        x=220, y=230, z=10,
    },

    {
        type = "Text",
        shortcut = "buy_info",
        font = "clean20",
        text = sandy_str.button_buy_info,
        align = "left vcenter",
        color = "505050",
        x=290, y=233, z=10,
    },

    {
        type = "LabeledButton",
        shortcut = "demo_button",
        bitmap = "framework/gfx/button",
        bitmap_hi = "framework/gfx/button_hi",
        font = "clean20",
        text = sandy_str.button_demo,
        text_shift_y = 3,
        mouse_click = "no_button",
        x=220, y=280, z=10,
    },

    {
        type = "Text",
        shortcut = "demo_info",
        font = "clean20",
        text = sandy_str.button_demo_info,
        align = "left vcenter",
        color = "505050",
        x=290, y=283, z=10,
    },
    
    {
        type = "Text",
        shortcut = "activate_header",
        font = "clean_header30",
        text = sandy_str.activate_header,
        align = "left top",
        color = "424040",
        x=150, y=360, z=10,
    },

    {
        type = "Text",
        shortcut = "activate_info",
        font = "clean20",
        text = sandy_str.activate_info,
        align = "left top",
        w = 500,
        color = "505050",
        x=150, y=405, z=10,
    },

    {
        type = "InputLine",
        font = "clean20",
        shortcut = "input",
        x=150, y=450, z=10,
        max_width = 380,
        on_finished = "create_button",
        activation_code = true,
        max_length = 16,
        color = "2a7601",
        click_sound = "input_text",
    },
    
    {
        type = "Text",
        shortcut = "invalid",
        font = "clean20",
        text = sandy_str.activate_invalid,
        align = "left top",
        color = "9c1111",
        x=150, y=490, z=10,
        disabled = true,
    },
    
    {
        type = "Text",
        font = "clean_header30",
        text = sandy_str.activate_completed_header,
        align = "center top",
        color = "424040",
        x=400, y=190, z=10,
        disabled = true,
        shortcut = "activated1",
    },

    {
        type = "Text",
        font = "clean20",
        text = sandy_str.activate_completed_info,
        align = "center top",
        w = 500,
        color = "505050",
        x=400, y=250, z=10,
        disabled = true,
        shortcut = "activated2",
    },

    {
        type = "LabeledButton",
        bitmap = "framework/gfx/button",
        bitmap_hi = "framework/gfx/button_hi",
        font = "clean20",
        text = sandy_str.activate_completed_continue,
        text_shift_y = 3,
        mouse_click = "continue_button",
        x=400, y=370, z=10,
        disabled = true,
        shortcut = "activated3",
    },
}

function ActivateFullVersion:init(options)
    gfx_full_screen(false)
    BaseView.init(self)
    gfx_load_font("framework/fonts/clean20.chr")
    gfx_load_font("framework/fonts/clean_header30.chr")
    self.check_code = true
    
    local width, height
    
    width, height = gfx_text_size("clean20", sandy_str.demo_info, "left top", 500)
    if height > 50 then
        local offset = 20
        self.shortcuts.buy_button.y = self.shortcuts.buy_button.y + offset
        self.shortcuts.demo_button.y = self.shortcuts.demo_button.y + offset
        self.shortcuts.buy_info.y = self.shortcuts.buy_info.y + offset
        self.shortcuts.demo_info.y = self.shortcuts.demo_info.y + offset
        self.shortcuts.activate_header.y = self.shortcuts.activate_header.y + offset
        self.shortcuts.activate_info.y = self.shortcuts.activate_info.y + offset
        self.shortcuts.input.y = self.shortcuts.input.y + offset
        self.shortcuts.invalid.y = self.shortcuts.invalid.y + offset
    end

    width, height = gfx_text_size("clean20", sandy_str.activate_info, "left top", 500)
    if height > 25 then
        local offset = -20
        self.shortcuts.activate_header.y = self.shortcuts.activate_header.y + offset
        self.shortcuts.activate_info.y = self.shortcuts.activate_info.y + offset
    end
end


function ActivateFullVersion:destroy()
    gfx_release_font("clean")
    gfx_release_font("clean_header")
    BaseView.destroy(self)
end


function ActivateFullVersion:render()
    gfx_render_box(0, 0, 800, 600, 1, 0, "ffffff")
    BaseView.render(self)
    if self.activation_fx then
        gfx_render_box(0, 0, 800, 600, self.activation_fx.val.alpha, 0, "ffffff")
    end
end


function ActivateFullVersion:update(dt)
    BaseView.update(self, dt)

    if self.check_code then
        self.shortcuts.invalid.enabled = false
        local code = self.shortcuts.input:get_text()
        if #code == 16 then
            if validate_activation_code(code) then
                activate_full_version(code)
                self.activation_fx = Animator:new()
                self.activation_fx:key("alpha", {{0, 0}, {1, 1}})
                self.check_code = false
            else
                self.shortcuts.invalid.enabled = true
            end
        end
    end
    
    if self.activation_fx then
        self.activation_fx:update(dt)
        if self.activation_fx:is_finished() then
            if self.activation_done then
                self.activation_fx = nil
            else
                for i, v in ipairs(self.objects) do
                    v.enabled = false
                end
                self.shortcuts.activated1.enabled = true
                self.shortcuts.activated2.enabled = true
                self.shortcuts.activated3.enabled = true
                self.activation_fx = Animator:new()
                self.activation_fx:update(dt)
                self.activation_fx:key("alpha", {{0, 1}, {0.3, 1}, {1.3, 0}})
                self.activation_done = true
            end
        end
    end
end


function ActivateFullVersion:yes_button(obj)
    net_open_web(game_website_url or "http://www.orchidgames.com")
end


function ActivateFullVersion:no_button(obj)
    sandy_done()
end


function ActivateFullVersion:continue_button(obj)
    sandy_done()
end


----------------------------------------------------------------------

-- sample code: KCFP-NNNN-PDDK-BHOK

function validate_activation_code(code)
    code = string.gsub(code, '-', '')
    code = string.gsub(code, ' ', '')

    if #code ~= 16 then
        return false
    end

    local a, b, c, crc, verify

    a, b, c, crc = string.byte(code, 1, 4)
    a, b, c, crc = a - 65, b - 65, c - 65, crc - 65
    verify = math.floor((a + 1) * 29 + (b + 17) * (c + 7) * 13) % 19
    if verify ~= crc or a < 0 or a >= 20 or b < 0 or b >= 20 or c < 0 or c >= 20 then return false end

    a, b, c, crc = string.byte(code, 5, 8)
    a, b, c, crc = a - 65, b - 65, c - 65, crc - 65
    verify = math.floor((a + 7) * 11 + (b + 23) * (c + 97) * 5) % 19
    if verify ~= crc or a < 0 or a >= 20 or b < 0 or b >= 20 or c < 0 or c >= 20 then return false end

    a, crc, b, c = string.byte(code, 9, 12)
    a, b, c, crc = a - 65, b - 65, c - 65, crc - 65
    verify = math.floor((a + 31) * 47 + (b + 89) * (c + 29) * 61) % 19
    if verify ~= crc or a < 0 or a >= 20 or b < 0 or b >= 20 or c < 0 or c >= 20 then return false end

    crc, a, b, c = string.byte(code, 13, 16)
    a, b, c, crc = a - 65, b - 65, c - 65, crc - 65
    verify = math.floor((a + 727) * 3 + (b + 31) * (c + 11) * 7) % 19
    if verify ~= crc or a < 0 or a >= 20 or b < 0 or b >= 20 or c < 0 or c >= 20 then return false end

    return true
end


function activate_full_version(code)
    file_save("fva.bin", "acode = \""..code.."\",", true)
    demo_mode = false
end


function check_activation_status()
    if demo_mode then
        log("Checking activation status")
        if file_exists("fva.bin") then
            local data = file_load_lua_table("fva.bin")

            if data.acode and validate_activation_code(data.acode) then
                demo_mode = false
                log("Activation confirmed")
                return
            end
        end

        log("No activation yet")
    end
end
